/*	Renegade Scripts.dll
	Example Plugin Code
	Copyright 2007 Whitedragon(MDB), Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#include "gmsettingsclass.h"

#define PluginName "Sounds Plugin"
#define PluginVersion "1.1"

struct RadioCommand
{
    char Text[256];
    char Sound[256];
	char Icon[256];
};

void Plugin_Load();
void Plugin_Unload();

typedef bool (*_RadioHook)(int, int, int, int, int);
typedef void (*_AddRadioHook)(_RadioHook);
extern _AddRadioHook AddRadioHook;

void Play_Random_Radio_Command(SimpleDynVecClass<RadioCommand *>& Vec, int Team, int ID);
bool Radio_Hook(int Team, int PlayerID, int a, int RadioID, int b);
void Load_Radio_Commands();
void Load_Taunt_Radio_Commands();

void KeyHookCall(void *Data);


class MDB_SSGM_KeyHook : public ScriptImpClass {
public:
	KeyHookStruct *k;
	int hookid,is_keyhook_set;
	int AddHook(const char *Key, GameObject *obj);
	void RemoveHook();
	void Detach(GameObject *obj);
	void Destroyed(GameObject *obj);
	virtual void KeyHookFunc() = 0;
};
class Iran_Radio_Taunt_Key : public MDB_SSGM_KeyHook {
	int Team;

	void Created(GameObject *obj);
	void KeyHookFunc();
};
